float4x4 mWorldViewProj;
float4x4 mWorldViewInv;
float gTime;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 uv			: TEXCOORD0;
    float3 color		: COLOR0;
};

float3x3 buildRotationMatrix(in float x, in float y) {
	float3x3 mat;
	
	mat[0][0] = cos(y);
	mat[0][1] = 0.0f;
	mat[0][2] = -sin(y);
	
	mat[1][0] = sin(x)*sin(y);
	mat[1][1] = cos(x);
	mat[1][2] = sin(x)*cos(y);
	
	mat[2][0] = cos(x)*sin(y);
	mat[2][1] = -sin(x);
	mat[2][2] = cos(x)*cos(y);
		
	return mat;
}

VS_OUTPUT main( in float4 pos : POSITION,
				in float2 uv : TEXCOORD0,
				in float3 normal : NORMAL)
{
	VS_OUTPUT Output;
	
	float time = gTime;
	float dist = length(pos);
	float rx = sin(time - dist*0.07f)*2.0f;
	float ry = sin(time*0.7f - dist*0.05f)*2.0f;
	float3x3 mat = buildRotationMatrix(rx, ry);
	pos.xyz = mul(pos.xyz, mat);
	normal = mul(normal, mat);
	
	float3 viewVector = float3(0.0f, 0.0f, -1.0f);
	
    Output.Position = mul(pos, mWorldViewProj);
    Output.color = dot(viewVector, normal);
    Output.uv = uv;
    
    
    return Output;
}